using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgPrintCautionTagChoosePatient
	/// </summary>
	public class DlgPrintCautionTagChoosePatient : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.Patient _patient;

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpPatients;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.ListView lvPatients;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.GroupBox grpMessage;
		private System.Windows.Forms.Label label1;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patients"></param>
		public DlgPrintCautionTagChoosePatient(ArrayList patients)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties(patients);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgPrintCautionTagChoosePatient));
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpPatients = new System.Windows.Forms.GroupBox();
			this.lvPatients = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.grpMessage = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.grpPatients.SuspendLayout();
			this.grpMessage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(444, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Select Patient";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 285);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(364, 276);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(284, 276);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.ttToolTip.SetToolTip(this.btnOK, "A patient must be chosen");
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 240);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpPatients
			// 
			this.grpPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatients.Controls.Add(this.lvPatients);
			this.grpPatients.Location = new System.Drawing.Point(60, 68);
			this.grpPatients.Name = "grpPatients";
			this.grpPatients.Size = new System.Drawing.Size(380, 204);
			this.grpPatients.TabIndex = 1;
			this.grpPatients.TabStop = false;
			this.grpPatients.Text = "Select Patient*";
			// 
			// lvPatients
			// 
			this.lvPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvPatients.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader1,
																						 this.columnHeader2,
																						 this.columnHeader3,
																						 this.columnHeader4});
			this.lvPatients.FullRowSelect = true;
			this.lvPatients.HideSelection = false;
			this.lvPatients.Location = new System.Drawing.Point(8, 16);
			this.lvPatients.MultiSelect = false;
			this.lvPatients.Name = "lvPatients";
			this.lvPatients.Size = new System.Drawing.Size(364, 180);
			this.lvPatients.TabIndex = 0;
			this.lvPatients.View = System.Windows.Forms.View.Details;
			this.lvPatients.SelectedIndexChanged += new System.EventHandler(this.lvPatients_SelectedIndexChanged);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Name";
			this.columnHeader1.Width = 120;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Patient ID";
			this.columnHeader2.Width = 80;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "DOB";
			this.columnHeader3.Width = 80;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "ABO/Rh";
			this.columnHeader4.Width = 80;
			// 
			// grpMessage
			// 
			this.grpMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpMessage.Controls.Add(this.label1);
			this.grpMessage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpMessage.Location = new System.Drawing.Point(60, 32);
			this.grpMessage.Name = "grpMessage";
			this.grpMessage.Size = new System.Drawing.Size(380, 36);
			this.grpMessage.TabIndex = 0;
			this.grpMessage.TabStop = false;
			// 
			// label1
			// 
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.label1.Location = new System.Drawing.Point(8, 12);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(360, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Selected unit was crossmatched/assigned to muliple patients.";
			this.label1.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// DlgPrintCautionTagChoosePatient
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(444, 301);
			this.Controls.Add(this.grpMessage);
			this.Controls.Add(this.grpPatients);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Print_Unit_Caution_Tag_&_Transfusion_Record_Form.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
		
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(452, 335);
			this.Name = "DlgPrintCautionTagChoosePatient";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Patient";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgPrintCautionTagChoosePatient_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpPatients, 0);
			this.Controls.SetChildIndex(this.grpMessage, 0);
			this.grpImage.ResumeLayout(false);
			this.grpPatients.ResumeLayout(false);
			this.grpMessage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		#region Properties

		/// <summary>
		/// Get/Set Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return _patient;
			}
		}

		#endregion


		#region Methods
		
		private void SetComponentProperties(ArrayList patients)
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC044.DlgPrintCautionTagChoosePatient());
			this.lvPatients.MultiSelect = false;
			PopulateListView(patients);
		}

		private void PopulateListView(ArrayList patients)
		{
			foreach (BOL.Patient patient in patients)
			{
				ListViewItem lVI = new ListViewItem();
				lVI.Tag = patient;
				lVI.Text = patient.DisplayName;
				lVI.SubItems.Add( patient.DisplayPatientID.ToString() );
				lVI.SubItems.Add( Common.VBECSDateTime.FormatDateString(patient.DateOfBirth) );
				lVI.SubItems.Add( patient.AboRh.AboRHText );
				this.lvPatients.Items.Add(lVI);
			}
		}

		#endregion


		#region Events

		private void lvPatients_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (lvPatients.SelectedItems.Count > 0)
			{
				ListViewItem lVI = lvPatients.SelectedItems[0];
				_patient = (BOL.Patient) lVI.Tag;
				this.btnOK.EnabledButton = true;
				this.ttToolTip.SetToolTip(btnOK, String.Empty);
			}
			else
			{
				this.btnOK.EnabledButton = false;
				this.ttToolTip.SetToolTip(btnOK, "A patient must be chosen");
			}
			this.SpeakListViewWithCheckBox(lvPatients);
		}

		#endregion

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
		
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgPrintCautionTagChoosePatient_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.ttToolTip.GetToolTip(this.btnOK);
			}

			this.SpeakMessage( textToSpeak );		
		}
	}
}

